#include <LCDWIKI_GUI.h> //Core graphics library
#include <LCDWIKI_SPI.h> //Hardware-specific library
#include <SoftwareSerial.h>
#define MODEL ILI9488_18
#define CS   8    
#define CD   10
#define RST  9
#define LED  -1  
//define some colour values
#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define ORANGE  0xFBE7
#define GREEN   0x07E0
#define LGREEN   0x3FE7
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define LPINK   0xE0FE
#define LEVNDR 0x9C7F
#define PINK 0xE0F0
LCDWIKI_SPI mylcd(MODEL,CS,CD,RST,LED); 
int x45,y45,x30,y30,x60,y60,x90,y90,x15,y15,x75,y75,x105,y105,x120,y120,x135,y135,x150,y150,x165,y165;
SoftwareSerial HC12_ser(7,6);
int recv_data=0,c=0;
char recv_char[3],ch;
int x,y,ang, right_to_left_scan_start_flag=1,left_to_right_scan_start_flag=0; 
float rad; 
void TFT_LCD_init()
 {
  mylcd.Init_LCD();
  mylcd.Fill_Screen(BLACK);
  mylcd.Set_Text_Mode(0);   
  mylcd.Set_Rotation(0);
  mylcd.Set_Text_Back_colour(BLACK);  
 }
void draw_radar_screen()
 {
  mylcd.Set_Text_Size(5);
  mylcd.Set_Text_colour(GREEN);
  mylcd.Print_String("RADAR",80,5); 
  mylcd.Set_Draw_color(RED);
  mylcd.Draw_Circle(160,200,150);
  mylcd.Draw_Line(10,200,310,200);  
  mylcd.Set_Text_Size(2);
  mylcd.Set_Text_colour(YELLOW);
  x15 = 160+150*sin(105/57.3);
  y15 = 200+150*cos(105/57.3);
  x30 = 160+150*sin(120/57.3);
  y30 = 200+150*cos(120/57.3);
  x45 = 160+150*sin(135/57.3);
  y45 = 200+150*cos(135/57.3);
  x60 = 160+150*sin(150/57.3);
  y60 = 200+150*cos(150/57.3);
  x75 = 160+150*sin(165/57.3);
  y75 = 200+150*cos(165/57.3);
  x90 = 160+150*sin(180/57.3);
  y90 = 200+150*cos(180/57.3);
  x105 = 160+150*sin(195/57.3);
  y105 = 200+150*cos(195/57.3);
  x120 = 160+150*sin(210/57.3);
  y120 = 200+150*cos(210/57.3);
  x135 = 160+150*sin(225/57.3);
  y135 = 200+150*cos(225/57.3);
  x150 = 160+150*sin(240/57.3);
  y150 = 200+150*cos(240/57.3);
  x165 = 160+150*sin(255/57.3);
  y165 = 200+150*cos(255/57.3); 
  mylcd.Print_String("15", x15-16, y15); 
  mylcd.Print_String("45", x45-5, y45+2); 
  mylcd.Print_String("30", x30-13, y30); 
  mylcd.Print_String("60", x60-3, y60); 
  mylcd.Print_String("90", x90, y90);  
  mylcd.Print_String("75", x75, y75+3); 
  mylcd.Print_String("105", x105, y105); 
  mylcd.Print_String("120", x120, y120); 
  mylcd.Print_String("135", x135, y135); 
  mylcd.Print_String("150", x150, y150);
  mylcd.Print_String("165", x165, y165); 
  mylcd.Set_Draw_color(BLACK);
  mylcd.Fill_Rectangle(10,201,310,350); 
 }
void setup() 
 {   
  TFT_LCD_init();
  draw_radar_screen();
  mylcd.Set_Text_Size(4);
  mylcd.Set_Text_colour(LEVNDR);
  mylcd.Print_String("New Object ",30,210);
  mylcd.Print_String("detected",45,250);
  mylcd.Set_Draw_color(LPINK);
  mylcd.Draw_Line(160,290,160,450);
  mylcd.Set_Text_Size(3);  
  mylcd.Set_Text_colour(LGREEN);
  mylcd.Print_String("Distance",5,300);
  mylcd.Print_String("cm",10,430);
  mylcd.Set_Text_colour(PINK); 
  mylcd.Print_String("Angle",185,300);
  mylcd.Print_String("degree",185,430);  
  HC12_ser.begin(9600); 
  while (!HC12_ser.available());
 }
void loop() 
 {
  if(HC12_ser.available()>0) 
    {
      ch = HC12_ser.read();
      if(ch=='s')
       {
         if(right_to_left_scan_start_flag)
           {
            ang = 95;
            right_to_left_scan_start_flag=0;
            left_to_right_scan_start_flag=1;
           }
         ang++;
         rad =  ang/57.3;
         x = 160+150*sin(rad);
         y = 200+150*cos(rad);
         mylcd.Set_Draw_color(YELLOW);
         mylcd.Draw_Line(160,200,x,y);
         delay(20);
         mylcd.Set_Draw_color(BLUE);
         mylcd.Draw_Line(160,200,x,y);
       } 
      else if(ch == 'd') 
        {
         recv_data = (recv_char[0]-48)*100  + (recv_char[1]-48)*10 + (recv_char[2]-48);
         mylcd.Set_Text_colour(MAGENTA); 
         mylcd.Set_Text_Size(7); 
         mylcd.Print_String("   ",5,350); 
         mylcd.Print_Number_Int(recv_data,5,350,3,' ',10); 
         recv_data=0;
         c=0;
       } 
      else if(ch == 'a') 
       {
         recv_data = (recv_char[0]-48)*100  + (recv_char[1]-48)*10 + (recv_char[2]-48);
         mylcd.Set_Text_colour(ORANGE); 
         mylcd.Set_Text_Size(7); 
         mylcd.Print_String("   ",185,350); 
         mylcd.Print_Number_Int(recv_data,185,350,3,' ',10);        
         recv_data=0; 
         c=0;
       }     
     else if(ch=='v')
       {
         if(left_to_right_scan_start_flag)
           {
            ang = 265;
            right_to_left_scan_start_flag=1;
            left_to_right_scan_start_flag=0;
           }
         ang--;  
         rad =  ang/57.3;
         x = 160+150*sin(rad);
         y = 200+150*cos(rad);
         mylcd.Set_Draw_color(YELLOW);
         mylcd.Draw_Line(160,200,x,y);
         delay(20);
         mylcd.Set_Draw_color(BLUE);
         mylcd.Draw_Line(160,200,x,y); 
       }  
     else 
      {
        recv_char[c] = ch;
        mylcd.Set_Draw_color(RED);
        mylcd.Draw_Line(160,200,x,y); 
        c++;
      }          
   }
 } 
